 ; Ŀ
 ;   Tea - centre justify an ss of text, move to the middle of a box.      
 ;   Copyright 1995, 1997, 2005, 2006, 2007, 2010 by Rocket Software Ltd.  
 ;   Computers make us more efficient, so we can have tea.                 
 ; 

 ; Ŀ
 ;   Trot - added utility - rotate an ss of text/attdefs around their      
 ;   common centre point.                                                  
 ; 
 (DEFUN C:TROT (/ ss pts ll ur pa)
  (setvar "cmdecho" 0)
  (command "undo" "m")
  (write-line "Select text to rotate: ")
  (setq ss (ssget '((-4 . "<or") (0 . "text") (0 . "attdef") (-4 . "or>"))))
  (if ss
      (progn
           (setq pts (bock ss))
           (setq pts (boctra pts))     ; translate into world ucs
           (setq ll (car pts))
           (setq ur (cadr pts))
           (setq pa (polar ll (angle ll ur) (/ (distance ll ur) 2.0)))
           (if (setq rotang (getangle "Rotation angle <90>: "))
               (setq rotang (* 180 (/ rotang pi)))
               (setq rotang 90))
           (command "rotate" ss "" pa rotang)))
  (command "undo" "end")
 (princ))
 ; Ŀ
 ;   C:Trot end.                                                           
 ; 

 ; Ŀ
 ;   Bock: find the box bounding the selection set of text or attdef       
 ;   entities which is passed as the sole argument.                        
 ; 
 (DEFUN BOCK (ss / num enam typ entt mxlst xmax xmin ymax ymin pl)
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (grtext -2 (itoa (setq num (1+ num))))
         (setq typ (cdr (assoc 0 (entget enam))))
         (setq mxlst (cron enam 0))
         (if xmax
             (setq xmax (max xmax (car mxlst)))
             (setq xmax (car mxlst)))
         (if xmin
             (setq xmin (min xmin (cadr mxlst)))
             (setq xmin (cadr mxlst)))
         (if ymax
             (setq ymax (max ymax (caddr mxlst)))
             (setq ymax (caddr mxlst)))
         (if ymin
             (setq ymin (min ymin (cadddr mxlst)))
             (setq ymin (cadddr mxlst))))
  (list (list xmin ymin) (list xmax ymax)))
 ; Ŀ
 ;   Bock end.                                                             
 ; 

 ; Ŀ
 ;   Boctra - translate a list of ((x x) (y y)) values.                    
 ; 
 (DEFUN BOCTRA (mxlst)
  (list (trans (car mxlst) 0 1) (trans (cadr mxlst) 0 1)))
 ; Ŀ
 ;   Boctralis end.                                                        
 ; 

 ; Ŀ
 ;   Cron - returns the corners of a text entity.                          
 ;   Arguments: Enam, a text entity ename.                                 
 ;              Offdis, the offset distance.                               
 ;   Rewritten 2010.10.10.                                                 
 ; 
 (DEFUN CRON (enam offdis / aa bb rota cc dd bheigt bwidth llangg lldist ll ul
                                                    lr ur xmax xmin ymax ymin)
  (setq aa (entget enam))
 ; Ŀ
 ;   The textbox function returns...hang on...from the notes below, a      
 ;   list containing the offset of the lower left point of the text from   
 ;   the 10 association point - typically 0,0,0 - and the offset of the    
 ;   upper right point from the ten point.  These are assumining that the  
 ;   text isn't obliqued or rotated, so if it is the program must adjust   
 ;   accordingly.  This program won't bother with obliquing, rotation is   
 ;   allowed.                                                              
 ; 
  (setq bb (textbox aa))
  (setq rota (cdr (assoc 50 aa)))
  (setq cc (car bb))                    ; ll offset from 10 of text
  (setq dd (cadr bb))                   ; ur offset from 10 of text
  (setq bheigt (- (cadr dd) (cadr cc)))
  (setq bwidth (- (car dd) (car cc)))
  (setq llangg (angle (list 0 0) cc))
  (setq lldist (distance (list 0 0) cc))
 ; Ŀ
 ;   Extract the real corner points of the text.                           
 ; 
  (setq ll (polar (cdr (assoc 10 aa)) (+ llangg rota) lldist))
  (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
  (setq lr (polar ll rota bwidth))
  (setq ur (polar lr (+ rota (/ pi 2)) bheigt))
 ; Ŀ
 ;   Find the maximum and minimum X and Y points.  These may not be the    
 ;   same as the corners of the text box, since the text may be rotated.   
 ; 
  (setq xmax (max (car ul) (car ll) (car ur) (car lr)))
  (setq xmin (min (car ul) (car ll) (car ur) (car lr)))
  (setq ymax (max (cadr ul) (cadr ll) (cadr ur) (cadr lr)))
  (setq ymin (min (cadr ul) (cadr ll) (cadr ur) (cadr lr)))
  (setq xmax (+ xmax offdis))
  (setq xmin (- xmin offdis))
  (setq ymax (+ ymax offdis))
  (setq ymin (- ymin offdis))
 ; Ŀ
 ;   And return the max and min x and y list.                              
 ; 
 (list xmax xmin ymax ymin))
 ; Ŀ
 ;   Cron end.                                                             
 ; 

 ; Ŀ
 ;   Mover - move an ss from one point to another while rotating it 360    
 ;   degrees.  Takes three arguments, a base point, a new point, and the   
 ;   ss name.  Returns nothing of use.                                     
 ; 
 (DEFUN MOVER (pa gnupt ss / dist angg)
  (setq jumps 30)
  (if (= (length pa) 3)
      (setq pa (list (car pa) (cadr pa))))
  (if (= (length gnupt) 3)
      (setq gnupt (list (car gnupt) (cadr gnupt))))
  (setq dist (/ (distance pa gnupt) jumps))
  (setq angg (angle pa gnupt))
  (repeat jumps
          (command ".move" ss "" "0,0" (polar (list 0 0) angg dist))
          (command ".rotate" ss "" pa (/ 360.0 jumps))
          (setq pa (polar pa angg dist))))
 ; Ŀ
 ;   Mover end.                                                            
 ; 


 ; Ŀ
 ;   Vbmx - Centre rejustify a column of text.                             
 ;   Takes three arguments: ss, the set of entities to rejustify, cc, the  
 ;   left side point, and rr, the right point.                             
 ; 
; (DEFUN VBMX (ss cc rr / xa num enam entt ten pty pa sp)
;  (setq xa (/ (+ (car cc) (car rr)) 2))
;  (setq num 0)
;  (while (setq enam (ssname ss num))
;         (setq num (1+ num))
;         (setq entt (entget enam))            ; get entity data
;         (setq ten (cdr (assoc 10 entt)))     ; save 10 point
;         (if (= typ "ATTDEF")
;             (setq entt (subst (cons 74 0) (assoc 74 entt) entt))
;             (setq entt (subst (cons 73 0) (assoc 73 entt) entt)))
;         (entmod (subst (cons 72 4) (assoc 72 entt) entt))  ; change
;         (setq entt (entget enam))            ; get changed edata
;         (setq new10 (cdr (assoc 10 entt)))   ; new 10 point
;         (setq dist (distance ten new10))     ; distance moved
;         (setq angl (angle new10 ten))        ; and angle
;         (setq new11 (cdr (assoc 11 entt)))   ; new middle point
;         (setq new11 (polar new11 angl dist)) ; move middle as 10 was
;         (entmod (subst (cons 11 new11) (assoc 11 entt) entt))
;         (setq entt (entget enam))            ; get entity data
;         (setq pty (cddr (assoc 11 entt)))    ; final middle y coord
;         (setq pa (cons xa pty))              ; final middle point
;         (entmod (subst (cons 11 pa) (assoc 11 entt) entt)))
; (princ))
 ; Ŀ
 ;   Vbmx end.                                                             
 ; 

 ; Ŀ
 ;   Vbmx - Centre rejustify a column of text.                             
 ;   Takes three arguments: ss, the set of entities to rejustify, xa, the  
 ;   left side point, and rr, the right point.                             
 ; 
 (DEFUN VBMX (ss xa rr / entt txang obliq dnang xb num enam ten typ new10
                                               dist angl new11 txpa txpb pa)
  (setq xa (list (/ (+ (car xa) (car rr)) 2)
                 (/ (+ (cadr xa) (cadr rr)) 2)
                 (/ (+ (caddr xa) (caddr rr)) 2)))
 ; Ŀ
 ;   Use the angle of the first text entity as the angle for all of them.  
 ; 
  (setq entt (entget (ssname ss 0)))
  (setq txang (cdr (assoc 50 entt)))
  (if (null (setq obliq (cdr (assoc 51 entt))))
      (setq obliq 0))
  (setq dnang (- txang (/ pi 2) obliq))
  (setq xb (polar xa dnang 100))
 ; Ŀ
 ;   For each entity, find its angle and the intersection of its baseline  
 ;   with a line from xa at dnang, the text down angle.                    
 ; 
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (setq entt (entget enam))            ; get changed edata
 ; Ŀ
 ;   Make it middle justified.                                             
 ; 
         (setq ten (cdr (assoc 10 entt)))     ; save 10 point
         (setq typ (cdr (assoc 0 entt)))      ; entity type
         (if (= typ "ATTDEF")
             (setq entt (subst (cons 74 0) (assoc 74 entt) entt))
             (setq entt (subst (cons 73 0) (assoc 73 entt) entt)))
         (entmod (subst (cons 72 4) (assoc 72 entt) entt))  ; change
         (setq entt (entget enam))            ; get changed edata
         (setq new10 (cdr (assoc 10 entt)))   ; new 10 point
         (setq dist (distance ten new10))     ; distance moved
         (setq angl (angle new10 ten))        ; and angle
         (setq new11 (cdr (assoc 11 entt)))   ; new middle point
         (setq new11 (polar new11 angl dist)) ; move middle as 10 was
         (entmod (subst (cons 11 new11) (assoc 11 entt) entt))
         (setq entt (entget enam))            ; get entity data
         (setq txang (cdr (assoc 50 entt)))
         (setq txpa (cdr (assoc 11 entt)))
         (setq txpb (polar txpa txang 100))
         (setq pa (inters xa xb txpa txpb nil))
         (entmod (subst (cons 11 pa) (assoc 11 entt) entt)))
 (princ))
 ; Ŀ
 ;   Vbmx end.                                                             
 ; 

 ; Ŀ
 ;   Tea.                                                                  
 ; 
 (DEFUN C:TEA (/ blip osmo *error* ss ll ur pa pa1 pts bp1 bp2 rad)
  (setvar "cmdecho" 0)
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (setvar "osmode" osmo)
   (setvar "blipmode" blip)
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Get an ss of text and attributes, or one block.                       
 ; 
  (write-line "Text/Block: ")
  (setq ss (ssget '((-4 . "<or") (0 . "text") (0 . "attdef")
                                 (0 . "insert") (-4 . "or>"))))
 ; Ŀ
 ;   Get two corner points, or one and a <Return>.                         
 ; 
  (setvar "osmode" 49)
  (setq ll (getpoint "Corner o'Box: "))
  (if (null (setq ur (getcorner ll "\nOther or <Same>: ")))
      (setq ur ll))
  (setvar "osmode" 0)
  (setq pa (polar ll (angle ll ur) (/ (distance ll ur) 2.0)))
 ; Ŀ
 ;   If the ss contained a single block, move it.                          
 ; 
  (cond ((and ss (= 1 (sslength ss))
                 (= "INSERT" (cdr (assoc 0 (entget (ssname ss 0))))))
         (setq pa1 (cdr (assoc 10 (entget (ssname ss 0)))))
         (mover pa1 pa ss))
 ; Ŀ
 ;   Otherwise remove all blocks from the ss and reposition it.            
 ; 
        (ss
         (setq ss (ssget "P" '((-4 . "<or") (0 . "text")
                                             (0 . "attdef") (-4 . "or>"))))
         (setq pts (bock ss))        ; added code to rejustify on block
         (setq pts (boctra pts))     ; translate into world ucs
         (setq bp1 (car pts))        ; of text rather than on sides of box
         (setq bp2 (cadr pts))       ; strictly
         (vbmx ss bp1 bp2)           ; for looks
         (setq pts (bock ss))
         (setq pts (boctra pts))     ; translate into world ucs
         (setq ll (car pts))
         (setq ur (cadr pts))
         (setq pa1 (polar ll (angle ll ur)
                             (setq rad (/ (distance ll ur) 2.0))))
         (mover pa1 pa ss)))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* ())
 (princ))

(write-line "C:Trot/C:Tea")
(princ)
